<?php $__env->startSection('content'); ?>
    <div class="row justify-content-end mb-4">
        <div class="col-xl-4 col-md-6">
            <form>
                <div class="input-group">
                    <input type="text" name="search" class="form-control form--control" value="<?php echo e(request()->search); ?>"
                        placeholder="<?php echo app('translator')->get('Search by Trx'); ?>">
                    <button class="input-group-text bg--base border-0 text--white">
                        <i class="las la-search"></i>
                    </button>
                </div>
            </form>
        </div>
    </div>
    <div class="row">
        <div class="col-lg-12">
            <div class="table-responsive">
                <table class="table table--responsive--md custom--table">
                    <thead>
                        <tr>
                            <th><?php echo app('translator')->get('Transaction'); ?></th>
                            <th><?php echo app('translator')->get('Ordered At'); ?></th>
                            <th><?php echo app('translator')->get('Amount'); ?></th>
                            <th><?php echo app('translator')->get('Quantity'); ?></th>
                            <th><?php echo app('translator')->get('Details'); ?></th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__empty_1 = true; $__currentLoopData = $orders; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $order): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                            <?php
                                $qty = @$order->orderItems->count();
                                $perUnitPrice = @$order->orderItems->first()->price;
                            ?>
                            <tr>
                                <td>
                                    <div class="td-wrapper">
                                        <span class="title d-block"><?php echo e($order->deposit->trx); ?></span>
                                        <a href="<?php echo e(route('user.deposit.history', ['search' => $order->deposit->trx])); ?>"
                                            class="info text--base">
                                            <?php echo app('translator')->get('View Details'); ?>
                                        </a>
                                    </div>
                                </td>
                                <td>
                                    <div class="td-wrapper">
                                        <?php echo e(showDateTime($order->created_at)); ?><br><?php echo e(diffForHumans($order->created_at)); ?>

                                    </div>
                                </td>
                                <td>
                                    <div class="td-wrapper">
                                        <span class="d-block"><?php echo e($qty); ?> <?php echo app('translator')->get('Qty'); ?> x
                                            <?php echo e(showAmount($perUnitPrice)); ?></span>
                                        <span class="fw-bold">
                                            <?php echo e(showAmount($order->total_amount)); ?>

                                        </span>
                                    </div>
                                </td>
                                <td>
                                    <span><?php echo e(@$order->orderItems->count()); ?></span>
                                </td>
                                
                                
                       <td>
    <div class="action-buttons">
        <a class="btn btn--base btn--sm" href="<?php echo e(route('user.order.details', $order->id)); ?>">
            Order Details
        </a>
    </div>
</td>

                                
                                
                                
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                            <tr>
                                <td class="text-muted text-center" colspan="100%"><?php echo e(__($emptyMessage)); ?></td>
                            </tr>
                        <?php endif; ?>
                    </tbody>
                </table>
            </div>
            <?php echo e(paginateLinks($orders)); ?>

        </div>
    </div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/user/orders.blade.php ENDPATH**/ ?>