<?php $__env->startSection('content'); ?>
    <?php
        $contactContent = getContent('contact_us.content', true);
    ?>

    <section class="contact-section py-120">
        <div class="container">
            <div class="row align-items-center flex-wrap-reverse">
                <div class="col-lg-5 col-xl-4">
                    <h4 class="heading text--base"><?php echo e(__(@$contactContent->data_values->heading)); ?></h4>
                    <p class="subheading mb-5">
                        <?php echo e(__(@$contactContent->data_values->subheading)); ?>

                    </p>
                    <div class="contact-info-wrapper row">
                        <div class="col-lg-12 col-md-6">
                            <div class="contact-info">
                                <span class="contact-info__icon"><i class="las la-envelope"></i></span>
                                <div class="contact-info__content">
                                    <h5 class="contact-info__title"><?php echo app('translator')->get('Mail Us'); ?></h5>
                                    <a href="mailto:<?php echo e(@$contactContent->data_values->email_address); ?>"
                                        class="contact-info__link"><?php echo e(@$contactContent->data_values->email_address); ?></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-6">
                            <div class="contact-info">
                                <span class="contact-info__icon"><i class="las la-phone-volume"></i></span>
                                <div class="contact-info__content">
                                    <h5 class="contact-info__title"><?php echo app('translator')->get('Phone'); ?></h5>
                                    <a href="tel:<?php echo e(@$contactContent->data_values->contact_number); ?>"
                                        class="contact-info__link"><?php echo e(@$contactContent->data_values->contact_number); ?></a>
                                </div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-md-6">
                            <div class="contact-info">
                                <span class="contact-info__icon"><i class="las la-map-marker"></i></span>
                                <div class="contact-info__content">
                                    <h5 class="contact-info__title"><?php echo app('translator')->get('Location'); ?></h5>
                                    <p class="contact-info__desc">
                                        <?php echo e(__(@$contactContent->data_values->contact_details)); ?>

                                    </p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-lg-7 offset-xl-1">
                    <div class="contact-form">
                        <form method="post" class="verify-gcaptcha">
                            <?php echo csrf_field(); ?>
                            <div class="row">
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="form--label"><?php echo app('translator')->get('Name'); ?></label>
                                        <input type="text" name="name" class="form--control"
                                            value="<?php echo e(old('name', @$user->fullname)); ?>"
                                            <?php if($user && $user->profile_complete): ?> readonly <?php endif; ?> required>
                                    </div>
                                </div>
                                <div class="col-sm-6">
                                    <div class="form-group">
                                        <label class="form--label"><?php echo app('translator')->get('Email'); ?></label>
                                        <input type="email" name="email" class="form--control"
                                            value="<?php echo e(old('email', @$user->email)); ?>"
                                            <?php if($user): ?> readonly <?php endif; ?> required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form--label"><?php echo app('translator')->get('Subject'); ?></label>
                                        <input type="text" name="subject" class="form--control"
                                            value="<?php echo e(old('subject')); ?>" required>
                                    </div>
                                </div>
                                <div class="col-sm-12">
                                    <div class="form-group">
                                        <label class="form--label"><?php echo app('translator')->get('Message'); ?></label>
                                        <textarea class="form--control" name="message" required><?php echo e(old('message')); ?></textarea>
                                    </div>
                                </div>
                                <?php if (isset($component)) { $__componentOriginalff0a9fdc5428085522b49c68070c11d6 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginalff0a9fdc5428085522b49c68070c11d6 = $attributes; } ?>
<?php $component = App\View\Components\Captcha::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('captcha'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\Captcha::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $attributes = $__attributesOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__attributesOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
<?php if (isset($__componentOriginalff0a9fdc5428085522b49c68070c11d6)): ?>
<?php $component = $__componentOriginalff0a9fdc5428085522b49c68070c11d6; ?>
<?php unset($__componentOriginalff0a9fdc5428085522b49c68070c11d6); ?>
<?php endif; ?>
                                <div class="col-sm-12">
                                    <div class="form-group mb-0">
                                        <button class=" btn btn--base w-100" type="submit"><?php echo app('translator')->get('Send Message'); ?></button>
                                    </div>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="contact-map-section">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-12 px-0">
                    <div class="contact-map">
                        <iframe
                            src="https://maps.google.com/maps?q=<?php echo e(@$contactContent->data_values->latitude); ?>,<?php echo e(@$contactContent->data_values->longitude); ?>&hl=es;z=14&amp;output=embed"
                            allowfullscreen="" loading="lazy" referrerpolicy="no-referrer-when-downgrade"></iframe>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <?php if($sections->secs != null): ?>
        <?php $__currentLoopData = json_decode($sections->secs); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $sec): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php echo $__env->make($activeTemplate . 'sections.' . $sec, \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chrislog/public_html/core/resources/views/templates/basic/contact.blade.php ENDPATH**/ ?>