<?php $__env->startSection('content'); ?>
    <section class="catalog-details-section section-bg py-60">
        <div class="container">
            <div class="card custom--card">
                <div class="card-body">
                    <h5 class="title"><?php echo e(__($product->name)); ?></h5>
                    <hr>
                    <div class="row justify-content-between">
                        <div class="col-lg-4 col-md-5">
                            <div class="product-thumb p-4">
                                <img
                                    src="<?php echo e(getImage(getFilePath('product') . '/' . $product->image, getFileSize('product'))); ?>">
                            </div>
                        </div>
                        <div class="col-lg-8 col-md-7">
                            <div class="product-top-info">
                                <div class="product-desc">
                                    <?php echo $product->description; ?>
                                </div>
                                <hr>
                                <div class="info-wrapper flex-align gap-3 pb-3">
                                    <p class="instock flex-align gap-2"><?php echo app('translator')->get('In Stock'); ?> <span
                                            class="pcs d-block fs-14 fw-bold"><?php echo e(getAmount($product->in_stock)); ?>

                                            <?php echo app('translator')->get('qty'); ?>.</span></p>
                                    <p class="price flex-align gap-2"><?php echo app('translator')->get('Per Quantity'); ?> <span
                                            class="amount d-block fs-14 fw-bold"><?php echo e(showAmount($product->price)); ?></span>
                                    </p>
                                </div>
                                <div class="share-sell d-flex justify-content-between">
                                    <div class="selling-card">
                                        <?php if($product->in_stock): ?>
                                            <button class="btn btn--base purchaseBtn"
                                                data-text="<?php echo e($product->name . ' | ' . strLimit(strip_tags($product->description), 270)); ?>"
                                                data-price="<?php echo e(showAmount($product->price)); ?>"
                                                data-qty="<?php echo e(getAmount($product->in_stock) . ' qty'); ?>"
                                                data-id="<?php echo e($product->id); ?>"
                                                data-amount="<?php echo e(getAmount($product->price)); ?>">
                                                <i class="las la-cart-plus"></i> <?php echo app('translator')->get('Purchase Now'); ?>
                                            </button>
                                        <?php else: ?>
                                            <button class="btn btn--base mt-2 no-drop" disabled>
                                                <i class="las la-cart-plus"></i> <?php echo app('translator')->get('Purchase Now'); ?>
                                            </button>
                                        <?php endif; ?>
                                    </div>
                                    <div class="blog-details__share mt-4 d-flex align-items-center flex-wrap">
                                        <h6 class="social-share__title mb-0 me-sm-3 me-1 d-inline-block"><?php echo app('translator')->get('Share'); ?>:
                                        </h6>
                                        <ul class="social-list">
                                            <li class="social-list__item"><a class="social-list__link flex-center"
                                                    target="_blank"
                                                    href="https://www.facebook.com/sharer/sharer.php?u=<?php echo e(urlencode(url()->current())); ?>"><i
                                                        class="fab fa-facebook-f"></i></a>
                                            </li>
                                            <li class="social-list__item"><a class="social-list__link flex-center"
                                                    target="_blank"
                                                    href="https://twitter.com/intent/tweet?text=my share text&amp;url=<?php echo e(urlencode(url()->current())); ?>">
                                                    <i class="fab fa-twitter"></i></a>
                                            </li>
                                            <li class="social-list__item"><a class="social-list__link flex-center"
                                                    target="_blank"
                                                    href="http://www.linkedin.com/shareArticle?mini=true&amp;url=<?php echo e(urlencode(url()->current())); ?>&amp;title=my share text&amp;summary=dit is de linkedin summary">
                                                    <i class="fab fa-linkedin-in"></i></a>
                                            </li>
                                        </ul>
                                    </div>

                                </div>

                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php if(!blank($relatedProducts)): ?>
                <div class="related-products mt-5">
                    <div class="catalog-item-wrapper">
                        <div class="catalog-item-wrapper__header d-flex align-items-center justify-content-between">
                            <h5 class="title mb-0"><?php echo app('translator')->get('Related Products'); ?></h5>
                        </div>
                        <hr>
                        <?php $__currentLoopData = $relatedProducts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $product): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <?php echo $__env->make($activeTemplate . 'partials/products', ['product' => $product], \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </div>
                </div>
            <?php endif; ?>
        </div>
    </section>

    <?php if (isset($component)) { $__componentOriginal7051c4b7a97d7f3525ebfb0398854502 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal7051c4b7a97d7f3525ebfb0398854502 = $attributes; } ?>
<?php $component = App\View\Components\PurchaseModal::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('purchase-modal'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\PurchaseModal::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
<?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal7051c4b7a97d7f3525ebfb0398854502)): ?>
<?php $attributes = $__attributesOriginal7051c4b7a97d7f3525ebfb0398854502; ?>
<?php unset($__attributesOriginal7051c4b7a97d7f3525ebfb0398854502); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal7051c4b7a97d7f3525ebfb0398854502)): ?>
<?php $component = $__componentOriginal7051c4b7a97d7f3525ebfb0398854502; ?>
<?php unset($__componentOriginal7051c4b7a97d7f3525ebfb0398854502); ?>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make($activeTemplate . 'layouts.frontend', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/chrislog/public_html/core/resources/views/templates/basic/product_details.blade.php ENDPATH**/ ?>