<div class="catalog-item">
    <span class="catalog-item__thumb">
        <img src="<?php echo e(getImage(getFilePath('product') . '/' . $product->image, getFileSize('product'))); ?>"
            alt="<?php echo app('translator')->get('image'); ?>">
    </span>
    <div class="catalog-item__content">
        <h6 class="catalog-item__title">
            <?php $text = $product->name.' | '.strLimit(strip_tags($product->description), 270); ?>
            <a href="<?php echo e(route('product.details', $product->id)); ?>" class="catalog-item__link">
                <?php echo $text;  ?>
            </a>
        </h6>
        <div class="catalog-item__info d-flex align-items-center">
            <p class="catalog-item__instock"><?php echo app('translator')->get('In Stock'); ?>: <span class="pcs"><?php echo e(getAmount($product->in_stock)); ?>

                    <?php echo app('translator')->get('qty'); ?>.</span></p>
            <p class="catalog-item__price">
                <?php echo app('translator')->get('Per Quantity'); ?>: <span class="amount"><?php echo e(showAmount($product->price)); ?></span>
            </p>
            <?php if($product->in_stock): ?>
                <button class="btn btn--base btn--sm purchaseBtn" data-text="<?php echo e($text); ?>"
                    data-price="<?php echo e(showAmount($product->price)); ?>"
                    data-qty="<?php echo e(getAmount($product->in_stock) . ' qty'); ?>" data-id="<?php echo e($product->id); ?>"
                    data-amount="<?php echo e(getAmount($product->price)); ?>">
                    <i class="las la-shopping-cart"></i> <?php echo app('translator')->get('Purchase'); ?>
                </button>
            <?php else: ?>
                <button class="btn btn--base btn--sm no-drop" disabled>
                    <i class="las la-shopping-cart"></i> <?php echo app('translator')->get('Purchase'); ?>
                </button>
            <?php endif; ?>
        </div>
    </div>
</div>
<?php /**PATH C:\laragon\www\DICT\chrislog\core\resources\views/templates/basic/partials/products.blade.php ENDPATH**/ ?>