@extends($activeTemplate.'layouts.master')

@section('content')
<div class="row justify-content-center">
    <div class="col-md-8">
        <div class="card custom--card">
            <div class="card-header card-header-bg">
                <h5 class="card-title text-center">{{__($pageTitle)}}</h5>
            </div>
            <div class="card-body">
                <form action="{{ route('user.fund-wallet.manualfund') }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    <div class="row">
                        <input type="hidden" name="amount" value="{{ $data['amount'] }}">
                        <div class="col-md-12 text-center">
                            <p class="text-center mt-2">@lang('You have requested') <b class="text-success">{{ showAmount($data['amount'])  }} {{__($general->cur_text)}}</b> , @lang('Please pay')
                                <b class="text-success">{{showAmount($data['final_amo']) .' '.$data['method_currency'] }} </b> @lang('for successful payment')
                            </p>
                            <h4 class="text-center mb-4">@lang('Please follow the instruction below')</h4>

                            <p class="my-4 text-center">@php echo  $data['gateway']->method->description @endphp</p>

                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <label class="form--label" for="payment_receipt">Upload payment receipt</label>
                                <input type="file" class="form--control" name="payment_receipt" id="" required accept="jpg,png,">
                                <pre class="text--base mt-1">@lang('Supported mimes'): jpg,jpeg,png,pdf</pre>
                            </div>
                            
                        </div>

                        <div class="col-md-12">
                            <div class="form-group">
                                <button type="submit" class="btn btn--base w-100">@lang('Submit')</button>
                            </div>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection