@extends($activeTemplate . 'layouts.master')

@section('content')

<div class="row justify-content-center">
    <div class="col-lg-8">
        <div class="card custom--card">
            <div class="card-header">
                <h5 class="card-title text-center">@lang('Fund Wallet')</h5>
            </div>
            <div class="card-body">
                <form class="register" id="paymentForm" action="" method="post">
                    @csrf
                    <div class="row">
                        <div class="form-group col-sm-12">
                            <label class="form--label">@lang('Enter amount')</label>
                            <input type="number" class="form--control amount" name="amount" value="{{ old('amount') }}" >
                        </div>

                        <div class="form-group col-sm-12">
                            <label class="form--label">Select payment method</label>

                            <select class="form-control mb-3 paymentMethod" name="method">
                              <option disabled selected>Select Method</option>

                              @if($isPaystackGatewayEnabled)
                                    <option value="paystack">Paystack</option>
                              @endif

                              {{-- <option value="1000">Manual</option> --}}
                            </select>
                          </div>

                        <div class="form-group text-center">
                            <button type="submit" id="btn-confirm" class="btn  btn--base w-50">@lang('Pay now')</button>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</div>
@endsection



@push('script')
<script src="//js.paystack.co/v1/inline.js"></script>

<script>
$(document).ready(function() {
    $('#btn-confirm').on('click', function(e) {
        e.preventDefault();

        const paymentMethod = $('.paymentMethod').val();
        const amount = $('.amount').val();

        console.log(paymentMethod);

        switch (paymentMethod) {
            case 'paystack':
                // Initialize Paystack payment modal
                let handler = PaystackPop.setup({
                    key: "{{ $paystackDetails['gatewayParameter']?->public_key?->value ?? '' }}",
                    email: "{{ $user->email }}",
                    amount: amount * 100,
                    onClose: function(){
                        alert('Window closed.');
                    },
                    callback: function(response){

                        window.location.href = "{{ route('user.paystack-payment.callback') }}?reference=" + response.reference;
                    }
                });
                handler.openIframe();
                break;

                case '1000':

                window.location.href = "{{ route('user.fund-wallet.manual') }}?am=" + amount + "&mt=" + paymentMethod;


            default:
                // alert('Invalid payment method selected.');
                // break;
        }
    });
});

</script>

@endpush
