@extends($activeTemplate . 'layouts.frontend')
@section('content')
    @php
        $policyPages = getContent('policy_pages.element', false, null, true);
        $register = getContent('register.content', true);
    @endphp
    @if (gs('registration'))
        <section class="account">
            <div class="account-inner">
                <div class="container">
                    <div class="row justify-content-center">
                        <div class="col-md-8 col-lg-7 col-xl-6">
                            <div class="account-form">
                                <div class="account-form__content mb-4">
                                    <h3 class="account-form__title mb-2">{{ __(@$register->data_values->heading) }}</h3>
                                    <p class="account-form__desc"> {{ __(@$register->data_values->subheading) }} </p>
                                    @include($activeTemplate . 'partials.social_login')
                                </div>
                                <form action="{{ route('user.register') }}" method="POST"
                                    class="verify-gcaptcha disableSubmission">
                                    @csrf

                                    <div class="row">
                                        @if (session()->get('reference') != null)
                                            <div class="col-md-6">
                                                <div class="form-group">
                                                    <label for="referenceBy" class="form--label">@lang('Reference by')</label>
                                                    <input type="text" name="referBy" id="referenceBy"
                                                        class="form--control" value="{{ session()->get('reference') }}"
                                                        readonly>
                                                </div>
                                            </div>
                                        @endif

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label">@lang('First Name')</label>
                                                <input type="text" class="form--control" name="firstname"
                                                    value="{{ old('firstname') }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label">@lang('Last Name')</label>
                                                <input type="text" class="form--control" name="lastname"
                                                    value="{{ old('lastname') }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label">@lang('E-Mail Address')</label>
                                                <input type="email" class="form--control checkUser" name="email"
                                                    value="{{ old('email') }}" required>
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label class="form--label">@lang('Password')</label>
                                                <input type="password"
                                                    class="form--control  @if (gs('secure_password')) secure-password @endif"
                                                    name="password" required>
                                            </div>
                                        </div>

                                        <div class="col-md-12">
                                            <div class="form-group">
                                                <label class="form--label">@lang('Confirm Password')</label>
                                                <input type="password" class="form--control" name="password_confirmation"
                                                    required>
                                            </div>
                                        </div>

                                        <x-captcha />

                                    </div>

                                    @if (gs('agree'))
                                        <div class="form-group">
                                            <input type="checkbox" id="agree" @checked(old('agree'))
                                                name="agree" required>
                                            <label for="agree">@lang('I agree with')</label> <span>
                                                @foreach ($policyPages as $policy)
                                                    <a href="{{ route('policy.pages', $policy->slug) }}" class="text--base">
                                                        {{ __($policy->data_values->title) }}
                                                    </a>
                                                    @if (!$loop->last)
                                                        ,
                                                    @endif
                                                @endforeach
                                            </span>
                                        </div>
                                    @endif
                                    <div class="form-group">
                                        <button type="submit" id="recaptcha" class="btn btn--base w-100">
                                            @lang('Register')</button>
                                    </div>
                                    <p class="mb-0 text-center">@lang('Already have an account?')
                                        <a href="{{ route('user.login') }}"
                                            class="have-account__link text--base">@lang('Login')</a>
                                    </p>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </section>
    @else
        @include($activeTemplate . 'partials.registration_disabled')
    @endif

    <div class="modal fade" id="existModalCenter" tabindex="-1" role="dialog" aria-labelledby="existModalCenterTitle"
        aria-hidden="true">
        <div class="modal-dialog modal-dialog-centered" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h6 class="modal-title method-name">@lang('You are with us')</h6>
                    <button type="button" class="btn-close" data-bs-dismiss="modal" aria-label="Close"></button>
                </div>
                <div class="modal-body">
                    <p>@lang('You already have an account please Login')</p>
                </div>
                <div class="modal-footer">
                    <a href="{{ route('user.login') }}" class="btn btn-sm btn--base w-100">@lang('Login')</a>
                </div>
            </div>
        </div>
    </div>
@endsection
@push('style')
    <style>
        .social-login-btn {
            border: 1px solid #cbc4c4;
        }

        .register-disable {
            height: 100vh;
            width: 100%;
            background-color: #fff;
            color: black;
            display: flex;
            align-items: center;
            justify-content: center;
        }

        .register-disable-image {
            max-width: 300px;
            width: 100%;
            margin: 0 auto 32px;
        }

        .register-disable-title {
            color: rgb(0 0 0 / 80%);
            font-size: 42px;
            margin-bottom: 18px;
            text-align: center
        }

        .register-disable-icon {
            font-size: 16px;
            background: rgb(255, 15, 15, .07);
            color: rgb(255, 15, 15, .8);
            border-radius: 3px;
            padding: 6px;
            margin-right: 4px;
        }

        .register-disable-desc {
            color: rgb(0 0 0 / 50%);
            font-size: 18px;
            max-width: 565px;
            width: 100%;
            margin: 0 auto 32px;
            text-align: center;
        }

        .register-disable-footer-link {
            color: #fff;
            background-color: #5B28FF;
            padding: 13px 24px;
            border-radius: 6px;
            text-decoration: none
        }

        .register-disable-footer-link:hover {
            background-color: #440ef4;
            color: #fff;
        }
    </style>
@endpush
@if (gs('secure_password'))
    @push('script-lib')
        <script src="{{ asset('assets/global/js/secure_password.js') }}"></script>
    @endpush
@endif
@push('script')
    <script>
        "use strict";
        (function($) {

            $('.checkUser').on('focusout', function(e) {
                var url = '{{ route('user.checkUser') }}';
                var value = $(this).val();
                var token = '{{ csrf_token() }}';

                var data = {
                    email: value,
                    _token: token
                }

                $.post(url, data, function(response) {
                    if (response.data != false) {
                        $('#existModalCenter').modal('show');
                    }
                });
            });
        })(jQuery);
    </script>
@endpush
