<?php

namespace App\Http\Controllers\Gateway;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Lib\FormProcessor;
use App\Models\AdminNotification;
use App\Models\Deposit;
use App\Models\GatewayCurrency;
use App\Models\Order;
use App\Models\OrderItem;
use App\Models\Product;
use App\Models\ProductDetail;
use App\Models\User;
use Illuminate\Http\Request;

class PaymentController extends Controller
{
    // public function depositInsert(Request $request)
    // {
    //     $request->validate([
    //         'gateway' => 'required',
    //         'currency' => 'required',
    //         'id' => 'required',
    //         'qty' => 'required|integer|gt:0',
    //     ]);

    //     $qty = $request->qty;

    //     $product = Product::active()->whereHas('category', function ($category) {
    //         return $category->active();
    //     })->findOrFail($request->id);

    //     if ($product->in_stock < $qty) {
    //         $notify[] = ['error', "Not enough stock available. Only {$product->in_stock} quantity left"];
    //         return back()->withNotify($notify);
    //     }

    //     $amount = ($product->price * $qty);


    //     $user = auth()->user();
    //     $gate = GatewayCurrency::whereHas('method', function ($gate) {
    //         $gate->where('status', Status::ENABLE);
    //     })->where('method_code', $request->gateway)->where('currency', $request->currency)->first();
    //     if (!$gate) {
    //         $notify[] = ['error', 'Invalid gateway'];
    //         return back()->withNotify($notify);
    //     }

    //     if ($gate->min_amount > $amount || $gate->max_amount < $amount) {
    //         $notify[] = ['error', 'Please follow deposit limit'];
    //         return back()->withNotify($notify);
    //     }

    //     $charge = $gate->fixed_charge + ($amount * $gate->percent_charge / 100);
    //     $payable = $amount + $charge;
    //     $finalAmount = $payable * $gate->rate;

    //     $order = new Order();
    //     $order->user_id = $user->id;
    //     $order->total_amount = $amount;
    //     $order->save();

    //     $data = new Deposit();
    //     $data->user_id = $user->id;
    //     $data->order_id = $order->id;
    //     $data->method_code = $gate->method_code;
    //     $data->method_currency = strtoupper($gate->currency);
    //     $data->amount = $amount;
    //     $data->charge = $charge;
    //     $data->rate = $gate->rate;
    //     $data->final_amount = $finalAmount;
    //     $data->btc_amount = 0;
    //     $data->btc_wallet = "";
    //     $data->trx = getTrx();
    //     $data->success_url = urlPath('user.deposit.history');
    //     $data->failed_url = urlPath('user.deposit.history');
    //     $data->save();

    //     $unsoldProductDetails = $product->unsoldProductDetails;

    //     for ($i = 0; $i < $qty; $i++) {
    //         if (@!$unsoldProductDetails[$i]) {
    //             continue;
    //         }
    //         $item = new OrderItem();
    //         $item->order_id = $order->id;
    //         $item->product_id = $product->id;
    //         $item->product_detail_id = $unsoldProductDetails[$i]->id;
    //         $item->price = $product->price;
    //         $item->save();
    //     }

    //     session()->put('Track', $data->trx);
    //     return to_route('user.deposit.confirm');
    // }


    public function depositInsert(Request $request)
    {
        $request->validate([
            'gateway' => 'required',
            'currency' => 'required',
            'id' => 'required',
            'qty' => 'required|integer|gt:0',
        ]);

        $qty = $request->qty;

        $product = Product::active()->whereHas('category', function($category){
            return $category->active();
        })->findOrFail($request->id);

        if($product->in_stock < $qty){
            $notify[] = ['error', "Not enough stock available. Only {$product->in_stock} quantity left"];
            return back()->withNotify($notify);
        }

        $amount = ($product->price * $qty);


        $gate = GatewayCurrency::whereHas('method', function ($gate) {
            $gate->where('status', Status::ENABLE);
        })->where('method_code', $request->gateway)->where('currency', $request->currency)->first();
        if (!$gate) {
            $notify[] = ['error', 'Invalid gateway'];
            return back()->withNotify($notify);
        }


        if ($gate->min_amount > $amount || $gate->max_amount < $amount) {
            $notify[] = ['error', 'Please follow deposit limit'];
            return back()->withNotify($notify);
        }

        $user = auth()->user();

        $charge = $gate->fixed_charge + ($amount * $gate->percent_charge / 100);
        $payable = $amount + $charge;
        $final_amo = $payable * $gate->rate;


        $order = new Order();
        $order->user_id = $user->id;
        $order->total_amount = $amount;
        $order->save();

        $order_id = $order->id;

        $data = new Deposit();
        $data->user_id = $user->id;
        $data->order_id = $order->id;
        $data->method_code = $gate->method_code;
        $data->method_currency = strtoupper($gate->currency);
        $data->amount = $amount;
        $data->charge = $charge;
        $data->rate = $gate->rate;
        $data->final_amount = $final_amo;
        $data->btc_amount = 0;
        $data->btc_wallet = "";
        $data->trx = getTrx();
        $data->save();

        $deposit_id = $data->id;


        $unsoldProductDetails = $product->unsoldProductDetails;

        for($i = 0; $i < $qty; $i++){
            if(@!$unsoldProductDetails[$i]){
                continue;
            }
            $item = new OrderItem();
            $item->order_id = $order->id;
            $item->product_id = $product->id;
            $item->product_detail_id = $unsoldProductDetails[$i]->id;
            $item->price = $product->price;
            $item->save();
        }

        session()->put('Track', $data->trx);

        if($request->gateway == '1001'){

            $user = User::findOrFail($user->id);

            if ($user && $user->balance >= $amount) {

                $newUserBalance = $user->balance - $amount;

                $updateUserBalance = $user->update(['balance' => $newUserBalance]);

                    if($updateUserBalance){

                        $order = Order::find($order_id);
                        $order->status = Status::ORDER_PAID;
                        $order->save();

                        $items = @$order->orderItems->pluck('product_detail_id')->toArray() ?? [];
                        ProductDetail::whereIn('id', $items)->update(['is_sold'=>Status::YES]);


                        $deposit = Deposit::find($deposit_id);
                        $deposit->status = Status::PAYMENT_SUCCESS;
                        $deposit->save();

                        $notify[] = ['success', "Purchase was successfull"];
                        return back()->withNotify($notify);
                    }
            } else {
                $notify[] = ['error', "Insufficient balance"];
                return back()->withNotify($notify);
            }
        }else{
            return to_route('user.deposit.confirm');
        }

    }

    public function depositConfirm()
    {
        $track = session()->get('Track');
        $deposit = Deposit::where('trx', $track)->where('status', Status::PAYMENT_INITIATE)->orderBy('id', 'DESC')->with('gateway')->firstOrFail();

        if ($deposit->method_code >= 1000) {
            return to_route('user.deposit.manual.confirm');
        }


        $dirName = $deposit->gateway->alias;
        $new = __NAMESPACE__ . '\\' . $dirName . '\\ProcessController';


        $data = $new::process($deposit);
        $data = json_decode($data);


        if (isset($data->error)) {
            $notify[] = ['error', $data->message];
            return back()->withNotify($notify);
        }
        if (isset($data->redirect)) {
            return redirect($data->redirect_url);
        }

        // for Stripe V3
        if (@$data->session) {
            $deposit->btc_wallet = $data->session->id;
            $deposit->save();
        }

        $pageTitle = 'Payment Confirm';
        return view("Template::$data->view", compact('data', 'pageTitle', 'deposit'));
    }


    public static function userDataUpdate($deposit, $isManual = null)
    {
        if ($deposit->status == Status::PAYMENT_INITIATE || $deposit->status == Status::PAYMENT_PENDING) {
            $deposit->status = Status::PAYMENT_SUCCESS;
            $deposit->save();

            $user = User::find($deposit->user_id);
            $order = $deposit->order;
            $order->status = Status::ORDER_PAID;
            $order->save();

            $methodName = $deposit->methodName();

            $items = @$order->orderItems->pluck('product_detail_id')->toArray() ?? [];
            ProductDetail::whereIn('id', $items)->update(['is_sold' => Status::YES]);

            if (!$isManual) {
                $adminNotification = new AdminNotification();
                $adminNotification->user_id = $user->id;
                $adminNotification->title = 'Payment successful via ' . $methodName;
                $adminNotification->click_url = urlPath('admin.deposit.successful');
                $adminNotification->save();
            }

            notify($user, $isManual ? 'DEPOSIT_APPROVE' : 'DEPOSIT_COMPLETE', [
                'method_name' => $methodName,
                'method_currency' => $deposit->method_currency,
                'method_amount' => showAmount($deposit->final_amount, currencyFormat: false),
                'amount' => showAmount($deposit->amount, currencyFormat: false),
                'charge' => showAmount($deposit->charge, currencyFormat: false),
                'rate' => showAmount($deposit->rate, currencyFormat: false),
                'trx' => $deposit->trx,
                'post_balance' => showAmount($user->balance),
                'details_link' => route('user.order.details', $order->id)
            ]);
        }
    }

    public function manualDepositConfirm()
    {
        $track = session()->get('Track');
        $data = Deposit::with('gateway')->where('status', Status::PAYMENT_INITIATE)->where('trx', $track)->first();
        abort_if(!$data, 404);
        if ($data->method_code > 999) {
            $pageTitle = 'Confirm Payment';
            $method = $data->gatewayCurrency();
            $gateway = $method->method;
            return view('Template::user.payment.manual', compact('data', 'pageTitle', 'method', 'gateway'));
        }
        abort(404);
    }

    public function manualDepositUpdate(Request $request)
    {
        $track = session()->get('Track');
        $data = Deposit::with('gateway')->where('status', Status::PAYMENT_INITIATE)->where('trx', $track)->first();
        abort_if(!$data, 404);
        $gatewayCurrency = $data->gatewayCurrency();
        $gateway = $gatewayCurrency->method;
        $formData = $gateway->form->form_data;

        $formProcessor = new FormProcessor();
        $validationRule = $formProcessor->valueValidation($formData);
        $request->validate($validationRule);
        $userData = $formProcessor->processFormData($request, $formData);


        $data->detail = $userData;
        $data->status = Status::PAYMENT_PENDING;
        $data->save();

        $order = $data->order;
        $items = @$order->orderItems->pluck('product_detail_id')->toArray() ?? [];
        ProductDetail::whereIn('id', $items)->update(['is_sold' => Status::YES]);


        $adminNotification = new AdminNotification();
        $adminNotification->user_id = $data->user->id;
        $adminNotification->title = 'Payment request from ' . $data->user->username;
        $adminNotification->click_url = urlPath('admin.deposit.details', $data->id);
        $adminNotification->save();

        notify($data->user, 'DEPOSIT_REQUEST', [
            'method_name' => $data->gatewayCurrency()->name,
            'method_currency' => $data->method_currency,
            'method_amount' => showAmount($data->final_amount, currencyFormat: false),
            'amount' => showAmount($data->amount, currencyFormat: false),
            'charge' => showAmount($data->charge, currencyFormat: false),
            'rate' => showAmount($data->rate, currencyFormat: false),
            'trx' => $data->trx
        ]);

        $notify[] = ['success', 'You have payment request has been taken'];
        return to_route('user.deposit.history')->withNotify($notify);
    }
}
